/**********************************************************************************/
/*    Demo program for:															  */
/*	  Board: AVR-PX128A1														  */
/*    Manufacture: OLIMEX                                                   	  */
/*	  COPYRIGHT (C) 2010														  */
/*    Designed by: Engineer Penko T. Bozhkov                                      */
/*    Module Name    :  main module                                               */
/*    File   Name    :  main.c                                                    */
/*    Revision       :  initial                                                   */
/*    Date           :  16.04.2010			                                      */
/*    Built with WinAVR-20081205					                              */
/**********************************************************************************/
/*	Generator output: PF3<48>! BUT1 adjust frequency value, BUT2 adjust range!	  */
/**********************************************************************************/
#include <ctype.h>
#include <avr/io.h>
//#include <util/delay.h>
#include "iox128a1.h"
#include "lcd.h"
#include <avr/interrupt.h>

#define STAT_LED_ON					PORTB.OUT &= ~0x08;
#define STAT_LED_OFF				PORTB.OUT |= 0x08;
#define PWM_OUT_ON					PORTF.OUT |= 0x08;
#define PWM_OUT_OFF					PORTF.OUT &= ~0x08;
#define Enable_PWM_Out				PORTF.DIR |= 0x08;
#define Disable_PWM_Out				PORTF.DIR &= ~0x08;
#define	FRQ_Value					TCF0.CCA
#define	FRQ_PRESCALER_1024			TCF0.CTRLA = 0x07;
#define	FRQ_PRESCALER_1				TCF0.CTRLA = 0x01;
#define	Enabel_FRQ_CCR_INT			TCF0.INTCTRLB |= 0xC0;	// High priority irq				
#define	FRQ_CCR_INT_Flag_CLR		TCF0.INTFLAGS |= 0x80;


void init_devices(void);
void delay(volatile unsigned long delay_counter);


/**********************************************************************************/
/*  Function name: delay                                                          */
/*  	Parameters                                                                */
/*          Input   :  No	                                                      */
/*          Output  :  No	                                                      */
/*	Action: Simple delay														  */
/**********************************************************************************/
void delay(volatile unsigned long delay_counter){
	while(delay_counter){delay_counter--;}
}


/**********************************************************************************/
/*  Function name: Ports_initial_initialization                                   */
/*  	Parameters                                                                */
/*          Input   :  No	                                                      */
/*          Output  :  No	                                                      */
/*	Action: Define initial ports state and direction.							  */
/**********************************************************************************/
void Ports_initial_initialization(void)
{
	//Ports initialization:
	PORTA.OUT = 0x00;
	PORTA.DIR = 0x00;

	PORTB.OUT = 0x08;	// STAT_LED off
	PORTB.DIR = 0b00001000;
	
	PORTC.OUT = 0b00010110;
	PORTC.DIR = 0b10111110;
	
	PORTD.OUT = 0b00000000;
	PORTD.DIR = 0b00000000;

	PORTE.OUT = 0b00000000;
	PORTE.DIR = 0b11111000;
	PORTE.INTCTRL = 0x0F;	// INT0LVL -> high priority; INT1LVL -> high priority
	PORTE.INT1MASK = 0x01;	// Select BUT1<PORTE0> as interrupt source	
	PORTE.INT0MASK = 0x02;	// Select BUT2<PORTE1> as interrupt source
	PORTE.INTFLAGS |= 0x03;	// clear flags
	PORTE.PIN0CTRL = 0x02;	// Sense falling edge on PORTE0
	PORTE.PIN1CTRL = 0x02;	// Sense falling edge on PORTE1

	PORTF.OUT = 0x00;
	PORTF.DIR = 0x00;		

	PORTH.OUT = 0x00;
	PORTH.DIR = 0x00;

	PORTJ.OUT = 0x00;
	PORTJ.DIR = 0x00;

	PORTK.OUT = 0x00;
	PORTK.DIR = 0x00;

	PORTQ.OUT = 0x00;
	PORTQ.DIR = 0x00;
}

/**********************************************************************************/
/*  Function name: init_devices	                                                  */
/*  	Parameters                                                                */
/*          Input   :  No			     		                                  */
/*          Output  :  No                                      	            	  */
/*	Action: Initialize all used ATXMEGA128A1 peripheral devices.	  			  */
/**********************************************************************************/
void init_devices(void){
	// All interrupts have to be disabled before initialization!
	SREG &= ~0b10000000;	// Clear SREG - Status Register, bit I: Global Interrupt Enable, and disable interrupts
	
	// Ports first initialization
	Ports_initial_initialization();

	/*** Clock Source Select ***/
	//CLK.CTRL = 0x00;		// System Clock Selection: 2 MHz Internal RC Oscillator
	CLK.PSCTRL = 0b00000000;// Select prescaler A division ratio "1", no division

	// External oscillator setup BEGIN
	OSC.XOSCCTRL = 0x4B;	// FRQRANGE[1:0] set to (2 MHz - 9 MHz), XOSCSEL[3:0] set to (0.4 - 16 MHz XTAL, 16K CLK)
	OSC.CTRL = 0x09;		// XOSCEN: External Oscillator Enable, and 2 MHz Internal RC Oscillator enable
	CCP = 0xD8;				// write to Configuration Change Protection Register: Protected IO register
	OSC.XOSCFAIL = 0x03;	// Clear XOSCFDIF:Failure Detection Interrupt Flag and set XOSCFDEN: Failure Detection Enable
	while(!(OSC.STATUS & 0x08));	// Wait until external clock source is stable and then select it for PLL clock input
	CCP = 0xD8;				// write to Configuration Change Protection Register: Protected IO register
	CLK.CTRL = 0x03;		// System Clock Selection: XOSC - External Oscillator or Clock
	// PLL setup BEGIN
	// To enable the PLL the following procedure must be followed:
	//OSC.PLLCTRL = 0x04;	// CLKSRC[1:0] = "00" -> 2 MHz Internal RC Oscillator
	OSC.PLLCTRL = 0xC4;		//1. Enable clock reference source: CLKSRC[1:0] = "11" -> External Clock Source; 
							//2.Set the multiplication factor and select the clock reference for the PLL: PLLFAC[4:0] = 0x04 -> 4x8.000 = 32MHz;
	while(!(OSC.STATUS & 0x08));	//3.Wait until the clock reference source (XTAL clock) is stable: PLLRDY: PLL Ready to be set
	OSC.CTRL |= 0x10;		//4.Enable the PLL: Set PLLEN: PLL Enable
	while(!(OSC.STATUS & 0x10)); //5.Wait until the PLL clock  is stable: PLLRDY: PLL Ready to be set
	// PLL Setup END
	CCP = 0xD8;				// write to Configuration Change Protection Register: Protected IO register
	CLK.CTRL = 0x04;		// System Clock Selection: PLL - Phase Locked Loop
	// External oscillator setup END

	// Init Timer/CounterF0: TCF0
	TCF0.CTRLA = 0x01;		// Prescaler: clk/1
	TCF0.CTRLB = 0x81;		// CCDEN - Compare or Capture Enable, FRQ
	TCF0.CTRLD = 0x00;		// Disable all
	TCF0.CNT = 0x0000;		// Clear CNT - Counter Register 
	TCF0.CCA = 0x000F;		// CCA - Compare Register, 32/16 = 2/2 = 1MHz Clock(0x000F)
	Disable_PWM_Out;
	//PORTF.DIR |= 0x08;		// PF3 -> PWM output 

	// Peripheral Clock Pclk Output to PD7
	//PORTCFG.CLKEVOUT = 0x02;	// Clock output on Port D pin 7
	//PORTD.DIR |= 0x80;			// PD7 -> OUT

	//LCD initialization
	LCD_Init();
	USARTE0.STATUS |= 0x80;	// Clear RXCIF: USART Receive Complete Interrupt Flag
	
	// Enable interrupts after initialization:
	PMIC.CTRL |= 0x05;	// HILVLEN: High Level Interrupt Enable and Low level also
	SREG |= 0b10000000;	// Set SREG - Status Register, bit I: Global Interrupt Enable, and enable interrupts
}


/**********************************************************************************/
/*  Function name: main	                                                  		  */
/*  	Parameters                                                                */
/*          Input   :  No			     		                                  */
/*          Output  :  No                                      	            	  */
/*	Action: All selected board tests will be done here.	  			  			  */
/**********************************************************************************/
int main(void){

	unsigned char BUT1_Counter = 5;
	unsigned char BUT2_Counter = 1;
	char Range = 'M';

	init_devices();
	LCD_Send_STR(1, "Welcome!");
	delay(2000000);					
	LCD_Send_STR(1,"   to   ");
	delay(2000000);					
	LCD_Send_STR(1," Olimex ");
	delay(2000000);
	LCD_Send_Long_STR(1,900000,"AVR-PX128A1_Frequency-Generator. Output: PF3<48>!Please Select Frequency! BUT1 adjust value, BUT2 adjust range! Default value is:");
	LCD_Send_STR(1," 1.00MHz");
	Enable_PWM_Out;
	
	while(1){
		// Toggle Stat Led
		STAT_LED_ON;
		delay(960000);
		STAT_LED_OFF;
		delay(960000);

		if(BUT1_On_Check){
			// BUT1 select value
			BUT1_Off_flag;
			BUT1_Counter--;
			// If Selected Range is MHz
			if(Range == 'M'){
				switch(BUT1_Counter){
					case 1:
					// 16MHz
					FRQ_Value = 0x0000;
					LCD_Send_STR(1,"16.00MHz");
					BUT1_Counter = 6;
					break;
					case 2:
					// 8MHz
					FRQ_Value = 0x0001;
					LCD_Send_STR(1," 8.00MHz");
					break;
					case 3:
					// 4MHz
					FRQ_Value = 0x0003;
					LCD_Send_STR(1," 4.00MHz");
					break;
					case 4:
					// 2MHz
					FRQ_Value = 0x0007;
					LCD_Send_STR(1," 2.00MHz");
					break;
					case 5:
					// 1MHz
					FRQ_Value = 0x000F;
					LCD_Send_STR(1," 1.00MHz");
					break;
					default:
					BUT1_Counter = 6;
					break;
				}
			}
			// If Selected Range is kHz
			if(Range == 'K'){
				switch(BUT1_Counter){
					case 1:
					// 900kHz
					FRQ_Value = 0x0011;
					LCD_Send_STR(1,"900.0kHz");
					BUT1_Counter = 20;
					break;
					case 2:
					// 800kHz
					FRQ_Value = 0x0013;
					LCD_Send_STR(1,"800.0kHz");
					break;
					case 3:
					// 700kHz
					FRQ_Value = 0x00016;
					LCD_Send_STR(1,"700.0kHz");
					break;
					case 4:
					// 600kHz
					FRQ_Value = 0x001A;
					LCD_Send_STR(1,"600.0kHz");
					break;
					case 5:
					// 500kHz
					FRQ_Value = 0x001F;
					LCD_Send_STR(1,"500.0kHz");
					break;
					case 6:
					// 400kHz
					FRQ_Value = 0x0027;
					LCD_Send_STR(1,"400.0kHz");
					break;
					case 7:
					// 300kHz
					FRQ_Value = 0x0035;
					LCD_Send_STR(1,"300.0kHz");
					break;
					case 8:
					// 200kHz
					FRQ_Value = 0x004F;
					LCD_Send_STR(1,"200.0kHz");
					break;
					case 9:
					// 100kHz
					FRQ_Value = 0x009F;
					LCD_Send_STR(1,"100.0kHz");
					break;
					case 10:
					// 90kHz
					FRQ_Value = 0x00B1;
					LCD_Send_STR(1," 90.0kHz");
					break;
					case 11:
					// 80kHz
					FRQ_Value = 0x00C7;
					LCD_Send_STR(1," 80.0kHz");
					break;
					case 12:
					// 70kHz
					FRQ_Value = 0x00E4;
					LCD_Send_STR(1," 70.0kHz");
					break;
					case 13:
					// 60kHz
					FRQ_Value = 0x0109;
					LCD_Send_STR(1," 60.0kHz");
					break;
					case 14:
					// 50kHz
					FRQ_Value = 0x013F;
					LCD_Send_STR(1," 50.0kHz");
					break;
					case 15:
					// 40kHz
					FRQ_Value = 0x018F;
					LCD_Send_STR(1," 40.0kHz");
					break;
					case 16:
					// 30kHz
					FRQ_Value = 0x0215;
					LCD_Send_STR(1," 30.0kHz");
					break;
					case 17:
					// 20kHz
					FRQ_Value = 0x031F;
					LCD_Send_STR(1," 20.0kHz");
					break;
					case 18:
					// 10kHz
					FRQ_Value = 0x063F;
					LCD_Send_STR(1," 10.0kHz");
					break;
					case 19:
					// 1kHz
					FRQ_Value = 0x3E7E;
					LCD_Send_STR(1,"  1.0kHz");
					break;
					default:
					BUT1_Counter = 20;
					break;
				}
			}
			// If Selected Range is Hz
			if(Range == 'H'){
				switch(BUT1_Counter){
					case 1:
					// 900Hz
					FRQ_Value = 0x0010;
					LCD_Send_STR(1,"900.0 Hz");
					BUT1_Counter = 20;
					break;
					case 2:
					// 800Hz
					FRQ_Value = 0x0012;
					LCD_Send_STR(1,"800.0 Hz");
					break;
					case 3:
					// 700Hz
					FRQ_Value = 0x00015;
					LCD_Send_STR(1,"700.0 Hz");
					break;
					case 4:
					// 600Hz
					FRQ_Value = 0x0019;
					LCD_Send_STR(1,"600.0 Hz");
					break;
					case 5:
					// 500Hz
					FRQ_Value = 0x001E;
					LCD_Send_STR(1,"500.0 Hz");
					break;
					case 6:
					// 400Hz
					FRQ_Value = 0x0026;
					LCD_Send_STR(1,"400.0 Hz");
					break;
					case 7:
					// 300Hz
					FRQ_Value = 0x0034;
					LCD_Send_STR(1,"300.0 Hz");
					break;
					case 8:
					// 200Hz
					FRQ_Value = 0x004D;
					LCD_Send_STR(1,"200.0 Hz");
					break;
					case 9:
					// 100Hz
					FRQ_Value = 0x009B;
					LCD_Send_STR(1,"100.0 Hz");
					break;
					case 10:
					// 90Hz
					FRQ_Value = 0x00AD;
					LCD_Send_STR(1," 90.0 Hz");
					break;
					case 11:
					// 80Hz
					FRQ_Value = 0x00C2;
					LCD_Send_STR(1," 80.0 Hz");
					break;
					case 12:
					// 70Hz
					FRQ_Value = 0x00DE;
					LCD_Send_STR(1," 70.0 Hz");
					break;
					case 13:
					// 60Hz
					FRQ_Value = 0x0103;
					LCD_Send_STR(1," 60.0 Hz");
					break;
					case 14:
					// 50Hz
					FRQ_Value = 0x0137;
					LCD_Send_STR(1," 50.0 Hz");
					break;
					case 15:
					// 40Hz
					FRQ_Value = 0x0185;
					LCD_Send_STR(1," 40.0 Hz");
					break;
					case 16:
					// 30Hz
					FRQ_Value = 0x0207;
					LCD_Send_STR(1," 30.0 Hz");
					break;
					case 17:
					// 20Hz
					FRQ_Value = 0x030B;
					LCD_Send_STR(1," 20.0 Hz");
					break;
					case 18:
					// 10Hz
					FRQ_Value = 0x0620;
					LCD_Send_STR(1," 10.0 Hz");
					break;
					case 19:
					// 1Hz
					FRQ_Value = 0x3E70;
					LCD_Send_STR(1,"  1.0 Hz");
					break;
					default:
					BUT1_Counter = 20;
					break;
				}	
			}

		}
		if(BUT2_On_Check){
			// BUT2 select range
			BUT2_Off_flag;
			BUT2_Counter++;
			if(BUT2_Counter == 1){
				// Select MHz 
				Range = 'M';
				FRQ_PRESCALER_1;
				BUT1_Counter = 6;
			}
			if(BUT2_Counter == 2){
				// Select kHz
				Range = 'K';
				FRQ_PRESCALER_1;
				BUT1_Counter = 20;
			}
			if(BUT2_Counter >= 3){
				// Select Hz
				Range = 'H';
				FRQ_PRESCALER_1024;
				BUT1_Counter = 20;
				BUT2_Counter = 0;
			}
		}

	}
}


/**********************************************************************************/
/*					BUT1 Interrupt Service Routine								  */
/*		Action: When BUT1 is pressed, set "BUT_On_flag"	flag					  */
/**********************************************************************************/
ISR(PORTE_INT1_vect)
{
	// user code here
	if(!(PORTE.IN & 0x01)){
		// BUT is pressed
		BUT1_On_flag;				
	}
	else{
		// Exit or check other flags
		BUT1_Off_flag;
	}
}


/**********************************************************************************/
/*					BUT2 Interrupt Service Routine								  */
/*		Action: When BUT2 is pressed, set "BUT2_On_flag"	flag				  */
/**********************************************************************************/
ISR(PORTE_INT0_vect)
{

	// user code here
	if(!(PORTE.IN & 0x02)){
		// BUT is pressed
		BUT2_On_flag;				
	}
	else{
		// Exit or check other flags
		BUT2_Off_flag;
	}
}


/**********************************************************************************/
/*			External Oscillator Failure Interrupt Service Routine				  */
/*		Action: When External Oscillator fail occur, send warning message to LCD. */
/*				In this situation CPU will be clocked by the internal 			  */
/*				2MHz RC oscillator!												  */
/**********************************************************************************/
ISR(OSC_XOSCF_vect)
{
	while(1){
		LCD_Send_STR(1, "  XTAL  ");
		delay(50000);
		delay(50000);
		LCD_Send_STR(1, " Clock: ");
		delay(50000);
		delay(50000);
		LCD_Send_STR(1, " !FAIL! ");
		delay(50000);
		delay(50000);
		LCD_Send_Long_STR(1,12500,"Please press RST button and check Q1 clock!!!");
	}
}


